/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.core.documentModel.phpElementData;

import java.util.ArrayList;
import java.util.Iterator;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDocBlock;
import org2.eclipse.php.internal.core.documentModel.phpElementData.IPHPDocTag;

public class PHPDocBlockImp
implements IPHPDocBlock {
    private static final long serialVersionUID = 1L;
    private static final String DEFAULT_DESCRIPTION_TEXT = "Enter description here...";
    private String shortDescription;
    private String longDescription;
    private IPHPDocTag[] tags;
    private int type;
    private int startPosition;
    private int endPosition;
    private String content;

    public PHPDocBlockImp(String shortDescription, String longDescription, IPHPDocTag[] tags, int type) {
        this.shortDescription = shortDescription;
        this.longDescription = longDescription;
        this.tags = tags;
        this.type = type;
    }

    @Override
    public String getShortDescription() {
        if (this.shortDescription == null) {
            return DEFAULT_DESCRIPTION_TEXT;
        }
        return this.shortDescription;
    }

    @Override
    public String getLongDescription() {
        if (this.longDescription == null) {
            return "";
        }
        return this.longDescription;
    }

    @Override
    public IPHPDocTag[] getTagsAsArray() {
        return this.tags;
    }

    @Override
    public IPHPDocTag[] getTags() {
        return this.tags;
    }

    @Override
    public Iterator getTags(int id) {
        if (this.tags == null) {
            return null;
        }
        ArrayList<IPHPDocTag> rv = new ArrayList<IPHPDocTag>(this.tags.length);
        int i = 0;
        while (i < this.tags.length) {
            IPHPDocTag tag = this.tags[i];
            if (tag.getID() == id) {
                rv.add(tag);
            }
            ++i;
        }
        return rv.iterator();
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public void setStartPosition(int value) {
        this.startPosition = value;
    }

    @Override
    public void setEndPosition(int value) {
        this.endPosition = value;
    }

    @Override
    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    @Override
    public int getStartPosition() {
        return this.startPosition;
    }

    @Override
    public int getEndPosition() {
        return this.endPosition;
    }

    @Override
    public boolean containsPosition(int position) {
        return position > this.getStartPosition() && position <= this.getEndPosition();
    }

    @Override
    public boolean hasTagOf(int id) {
        Iterator tagsOf = this.getTags(id);
        return tagsOf != null && tagsOf.hasNext();
    }

    public void setContent(String comment) {
        this.content = comment;
    }

    public String getContent() {
        return this.content;
    }
}

